USE AdventureWorks2014
GO
IF OBJECT_ID('dbo.ufnLeadingZeros_new') IS NOT NULL
BEGIN
	DROP FUNCTION [dbo].[ufnLeadingZeros_new];
END
GO

CREATE FUNCTION [dbo].[ufnLeadingZeros_new](
    @Value int
) 

RETURNS varchar(8)
WITH SCHEMABINDING, RETURNS NULL ON NULL INPUT  

AS 
BEGIN
    DECLARE @ReturnValue varchar(8);

    SET @ReturnValue = CONVERT(varchar(8), @Value);
    SET @ReturnValue = REPLICATE('0', 8 - DATALENGTH(@ReturnValue)) + @ReturnValue;

    RETURN (@ReturnValue);
END;
GO

SET STATISTICS TIME ON
GO
DBCC FREEPROCCACHE
GO

DECLARE @SalesOrderID INT, @CurrencyRateID VARCHAR(8)

SELECT @SalesOrderID=SalesOrderID, @CurrencyRateID = dbo.ufnLeadingZeros(CurrencyRateID) 
FROM Sales.SalesOrderHeaderEnlarged;
GO
DECLARE @SalesOrderID INT, @CurrencyRateID VARCHAR(8)

SELECT @SalesOrderID=SalesOrderID, @CurrencyRateID = dbo.ufnLeadingZeros_new(CurrencyRateID) 
FROM Sales.SalesOrderHeaderEnlarged;
GO

SELECT OBJECT_NAME(object_id, database_id) AS FunctionName, execution_count, total_elapsed_time, total_worker_time
FROM sys.dm_exec_function_stats
WHERE database_id = DB_ID();
GO

SELECT SUM(CASE WHEN CurrencyRateID IS NOT NULL THEN 1 ELSE 0 END) AS NOTNULL,
	   SUM(CASE WHEN CurrencyRateID IS NULL THEN 1 ELSE 0 END) AS NULLVALUE,
	   COUNT(*) AS TotalRows
FROM Sales.SalesOrderHeaderEnlarged;
GO